import sys

try:
    import requests # pip install requests or pip3 install requests
except ImportError:
    print("Please install requests library (pip install requests or pip3 install requests)")
    sys.exit()

token = input("Token: ")

hostname = input("FileMaker Server Host Name: ")
fms_api_base = "https://" + hostname + "/fmi/admin/api/v2"

fms_login = "/user/auth"

headers = {
    "Authorization": "PKI " + token
}

endpoint = fms_api_base + fms_login
r = requests.post(endpoint, headers = headers)

print("Status Code:", r.status_code)
print("Response:", r.json()["response"])
print("Messages:", r.json()["messages"])